﻿using System;
using System.Web.Security.AntiXss;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class BaseControlLabel : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
        }
        public string Text
        {
            get
            {
                return LabelID.Text;
            }
            set
            {
                LabelID.Text = AntiXssEncoder.HtmlEncode(value, false);
            }
        }

        public string LabelText
        {
            get
            {
                return LabelforLabelID.Text;
            }
            set
            {
                LabelforLabelID.Text = value;
            }
        }

        public string Tooltip
        {
            set
            {
                LabelforLabelID.ToolTip = value;
                LabelID.ToolTip = value;
            }
        }

        public bool IncludeLabel
        {
            set
            {
                LabelforLabelID.Visible = value;
            }
        }

        public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel)
        {
            if (!string.IsNullOrEmpty(tooltip))
            {
                Tooltip = tooltip;
            }
            if (!string.IsNullOrEmpty(text))
            {
                Text = text;
            }
            if (!string.IsNullOrEmpty(labelText))
            {
                LabelText = labelText;
            }

            IncludeLabel = includeLabel;
        }
    }
}